/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.potion;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import org.bukkit.craftbukkit.v1_18_R2.potion.CraftPotionUtil;
import org.bukkit.potion.PotionBrewer;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class CraftPotionBrewer
implements PotionBrewer {
    private static final Map<PotionType, Collection<PotionEffect>> cache = Maps.newHashMap();

    @Override
    public Collection<PotionEffect> getEffects(PotionType damage, boolean upgraded, boolean extended) {
        if (cache.containsKey((Object)damage)) {
            return cache.get((Object)damage);
        }
        List mcEffects = Potion.m_43489_((String)CraftPotionUtil.fromBukkit(new PotionData(damage, extended, upgraded))).m_43488_();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (MobEffectInstance effect : mcEffects) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        cache.put(damage, (Collection<PotionEffect>)builder.build());
        return cache.get((Object)damage);
    }

    @Override
    public Collection<PotionEffect> getEffectsFromDamage(int damage) {
        return new ArrayList<PotionEffect>();
    }

    @Override
    public PotionEffect createEffect(PotionEffectType potion, int duration, int amplifier) {
        return new PotionEffect(potion, potion.isInstant() ? 1 : (int)((double)duration * potion.getDurationModifier()), amplifier);
    }
}

